unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Registry;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
const
  MainPath = 'Software\Microsoft\Windows\CurrentVersion\Uninstall\';
var
  Reg : TRegistry;
  Lista : TStringList;
  i : Integer;
  NomeUninst : String;
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    Lista := TStringList.Create;
    try
// abre a chave para procurar programas
      if Reg.OpenKey(MainPath,False) then begin
// pega a lista de programas
        Reg.GetKeyNames(Lista);
// processa todos os programas
        for i := 0 to Lista.Count-1 do begin
          Reg.CloseKey;
          if Reg.OpenKey(MainPath+Lista[i],False) then
// verifica se UninstallString e DisplayName esto preenchidos
            if Reg.ReadString('UninstallString') <> '' then begin
              NomeUninst := Reg.ReadString('DisplayName');
              if NomeUninst <> '' then
                Listbox1.Items.Add(NomeUninst);
            end;
        end;
      end;
    finally
      Lista.Free;
    end;
  finally
    Reg.Free;
  end;
end;

end.
